package com.resteasy.series.queryparam;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path("/customer")
public interface ICustomerService {

	// http://localhost:8080/RestEasy-QueryParam/resteasy/customer/welcome?custname=Federer  - Tomcat 7.0.x
	// http://localhost:9090/RestEasy-QueryParam/resteasy/customer/welcome?custname=Leyton   - JBoss AS7
	@GET
	@Path("/welcome")
	public Response welcomeCustomer(@QueryParam("custname") String userName);

	// http://localhost:8080/RestEasy-QueryParam/resteasy/customer/custinfo?id=21001&name=roddick&age=29  - Tomcat 7.0.x
	// http://localhost:9090/RestEasy-QueryParam/resteasy/customer/custinfo?id=21002&name=nadal&age=28    - JBoss AS7
	@GET
	@Path("/custinfo")
	public Response printCustomerInfo(
			@QueryParam("id") String custId, 
			@QueryParam("name") String custName, 
			@QueryParam("age") String custAge);
}