package test.resteasy.series.queryparam;

import javax.ws.rs.HttpMethod;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

public class TestCustomerService {

	public static void main(String[] args) throws Exception {

		// setting & invoking first request
		System.out.println("Executing first service with single parameter");
		String url = "http://localhost:9090/RestEasy-QueryParam/resteasy/customer/welcome?custname=Leyton";
		String responseString1 = testCustomerServiceForSingleParameter(url);
		System.out.println("Response String for First Service : " + responseString1);

		// setting & invoking second request
		System.out.println("\n\nExecuting second service with multiple parameter");
		String url2 = "http://localhost:9090/RestEasy-QueryParam/resteasy/customer/custinfo?id=21002&name=nadal&age=28";
		String responseString3 = testCustomerServiceWithMultipleParameters(url2);
		System.out.println("Response String for Second Service : " + responseString3);
	}

	/**
	 * using ClientRequest and ClientResponse classes from  org.jboss.resteasy.client
	 * @param url
	 * @throws Exception
	 */
	@SuppressWarnings("deprecation")
	public static String testCustomerServiceForSingleParameter(String url) throws Exception {

		// local variables
		ClientRequest clientRequest = null;
		ClientResponse<String> clientResponse = null;
		int responseCode;
		String responseString = null;

		try{
			clientRequest = new ClientRequest(url);
			clientRequest.setHttpMethod(HttpMethod.GET);
			clientRequest.accept(MediaType.APPLICATION_FORM_URLENCODED);
			clientResponse = clientRequest.get(String.class);

			responseCode = clientResponse.getResponseStatus().getStatusCode();
			System.out.println("Response code: " + responseCode);

			if(clientResponse.getResponseStatus().getStatusCode() != 200) {
				throw new RuntimeException("Failed with HTTP error code : " + responseCode);
			}

			System.out.println("ResponseMessageFromServer: " + clientResponse.getResponseStatus().getReasonPhrase());
			responseString = clientResponse.getEntity();
		}
		catch(Exception ex) {
			ex.printStackTrace();
		}
		finally{
			// release resources, if any
			clientResponse.close();
			clientRequest.clear();
		}
		return responseString;
	}

	/**
	 * using ResteasyClient, ResteasyWebTarget and Response classes from org.jboss.resteasy.client
	 * @param url
	 */
	public static String testCustomerServiceWithMultipleParameters(String url) throws Exception {

		// local variables
		ResteasyClient resteasyClient = null;
		ResteasyWebTarget resteasyWebTarget = null;
		Response response = null;
		int responseCode;
		String responseString = null;

		try{
			resteasyClient = new ResteasyClientBuilder().build();
			resteasyWebTarget = resteasyClient.target(url);
			response = resteasyWebTarget.request().get();

			responseCode = response.getStatus();
			System.out.println("Response code: " + responseCode);

			if (response.getStatus() != 200) {
				throw new RuntimeException("Failed with HTTP error code : " + responseCode);
			}

			System.out.println("ResponseMessageFromServer: " + response.getStatusInfo().getReasonPhrase());
			responseString = response.readEntity(String.class);

		}
		catch(Exception ex){
			ex.printStackTrace();
		}
		finally{
			// release resources, if any
			response.close();
		}
		return responseString;
	}

	/**
	 * using Client, WebTarget from core JAX-RS classes javax.ws.rs.client
	 * @param url
	 */
	/*public static String testClient(String url) {

		// local variables
		Client client = null;
		WebTarget webTarget = null;
		String responseString = null;

		try {
			client = ClientBuilder.newClient();
			webTarget = client.target(url);
			client.property("accept", MediaType.APPLICATION_FORM_URLENCODED);
			responseString = webTarget.request(MediaType.APPLICATION_FORM_URLENCODED).get(String.class);
		}
		catch(Exception ex) {
			ex.printStackTrace();
		}
		finally{
			// release resources, if any
			client.close();
		}
		return responseString;
	}*/
}