package com.resteasy.series.spring.mvc.integration.service;

import in.benchresources.cdm.customer.CustomerListType;
import in.benchresources.cdm.customer.CustomerType;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

import com.resteasy.series.spring.mvc.integration.dao.CustomerDAO;
import com.resteasy.series.spring.mvc.integration.model.Customer;

@Controller
public class CustomerServiceImpl implements ICustomerService {

	@Autowired
	private CustomerDAO customerDAO;

	@Override
	public String createOrSaveNewCustomerInfo(CustomerType customerType) {

		Customer newCustomer = new Customer();
		newCustomer.setCustomerId(customerType.getCustomerId());
		newCustomer.setName(customerType.getName());
		newCustomer.setAge(customerType.getAge());
		return customerDAO.insertNewCustomer(newCustomer);
	}

	@Override
	public CustomerType getCustomerInfo(int customerId) {

		Customer getCustomer = customerDAO.getCustomer(customerId);

		CustomerType customerType = new CustomerType();
		customerType.setCustomerId(getCustomer.getCustomerId());
		customerType.setName(getCustomer.getName());
		customerType.setAge(getCustomer.getAge());
		return customerType;
	}

	@Override
	public CustomerListType getAllCustomerInfo() {

		List<Customer> lstCustomer = customerDAO.getAllCustomer();
		CustomerListType customerListType = new CustomerListType();

		for(Customer customer : lstCustomer){
			CustomerType customerType = new CustomerType();
			customerType.setCustomerId(customer.getCustomerId());
			customerType.setName(customer.getName());
			customerType.setAge(customer.getAge());
			customerListType.getCustomerType().add(customerType);
		}
		return customerListType;
	}

	@Override
	public ModelAndView viewAllCustomer() {

		CustomerListType customerListType = getAllCustomerInfo();
		return new ModelAndView("viewAllCustomer", "customerListType", customerListType);
	}
}