import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class CreateTableUsingJDBCPreparedStatement {

	public static void main(String[] args) {

		// variables
		Connection connection = null;
		PreparedStatement preparedStatement = null;

		// Step 1: Loading or registering MySQL JDBC driver class
		try {
			Class.forName("com.mysql.jdbc.Driver");
		}
		catch(ClassNotFoundException cnfex) {
			System.out.println("Problem in loading or registering MySQL JDBC driver");
			cnfex.printStackTrace();
		}

		// Step 2: Opening database connection
		try {

			// Step 2.A: Create and get connection using DriverManager class
			connection = DriverManager.getConnection("jdbc:mysql://localhost:3306/PLAYER_INFO", "root", "root@123"); 

			// create SQL query to create new table PLAYER
			String sqlQuery = "CREATE TABLE PLAYER (" +
					" PLAYER_ID INT(6) NOT NULL AUTO_INCREMENT, " +
					" NAME VARCHAR(50) NOT NULL, " + 
					" AGE INT(3) NOT NULL, " + 
					" MATCHES INT(3) NOT NULL, " + 
					" PRIMARY KEY (`PLAYER_ID`))";

			// Step 2.B: Creating JDBC PreparedStatement 
			preparedStatement = connection.prepareStatement(sqlQuery);

			// Step 2.C: Executing SQL & retrieve data into ResultSet
			int sqlQueryResult = preparedStatement.executeUpdate();

			// output of database creation
			if(0 == sqlQueryResult) {
				System.out.println("New table PLAYER created under PLAYER_INFO database successfully using PreparedStatement Interface");
			}
			else {
				System.out.println("Error in creating table PLAYER created under PLAYER_INFO database");
			}
		}
		catch(SQLException sqlex){
			sqlex.printStackTrace();
		}
		finally {

			// Step 3: Closing database connection
			try {
				if(null != connection) {

					// cleanup resources, once after processing
					preparedStatement.close();

					// and then finally close connection
					connection.close();
				}
			}
			catch (SQLException sqlex) {
				sqlex.printStackTrace();
			}
		}
	}
}